/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker;

import LegendaryCardMaker.CustomCardMaker.CustomCardMaker;
import LegendaryCardMaker.CustomCardMaker.CustomCardMakerToolbar;
import LegendaryCardMaker.CustomCardMaker.structure.CustomCard;
import LegendaryCardMaker.CustomCardMaker.structure.CustomElement;
import LegendaryCardMaker.CustomCardMaker.structure.ElementBackgroundImage;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class CustomCardMakerFrame
extends JDialog {
    public CustomCardMaker hm = new CustomCardMaker();
    JLabel label;
    JLabel backLabel;
    JLayeredPane layers;
    CustomCardMakerToolbar hmt;

    public CustomCardMakerFrame(CustomCard hc) {
        this.hm.setCard(hc);
        this.setTitle("Card Editor: " + hc.template.templateDisplayName);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.backLabel = new JLabel();
        this.backLabel.setOpaque(true);
        BufferedImage bi = this.hm.generateCard();
        ImageIcon icon = new ImageIcon(this.resizeImage(new ImageIcon(bi), 0.5));
        this.label = new JLabel(icon);
        this.label.setOpaque(false);
        this.label.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        this.backLabel.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        this.layers = new JLayeredPane();
        this.layers.setLayout(null);
        this.layers.add(this.label, JLayeredPane.PALETTE_LAYER, -1);
        this.layers.add(this.backLabel, JLayeredPane.DEFAULT_LAYER, -1);
        this.layers.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        this.layers.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        this.layers.addMouseListener(new MouseListener(){
            int startX = 0;
            int startY = 0;

            @Override
            public void mouseReleased(MouseEvent e) {
                ElementBackgroundImage bgi = null;
                for (CustomElement el : CustomCardMakerFrame.this.hm.card.template.elements) {
                    if (!(el instanceof ElementBackgroundImage)) continue;
                    bgi = (ElementBackgroundImage)el;
                }
                if (bgi != null) {
                    bgi.imageOffsetX += e.getX() - this.startX;
                    bgi.imageOffsetY += e.getY() - this.startY;
                }
                CustomCardMakerFrame.this.reRenderCard();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.startX = e.getX();
                this.startY = e.getY();
                System.out.println("Pressed: " + this.startX + ":" + this.startY);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.layers);
        this.add(scroll);
        int scrollBarSize = (Integer)UIManager.get("ScrollBar.width");
        this.setSize((int)((double)CustomCardMaker.cardWidth / 1.8), (int)((double)CustomCardMaker.cardHeight / 1.8));
        this.hmt = new CustomCardMakerToolbar(this.hm, this);
        this.setJMenuBar(this.hmt);
        this.setVisible(true);
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, double scale) {
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int type = 2;
        BufferedImage image = new BufferedImage(w, h, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, w, h, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, int width, int height) {
        int type = 2;
        BufferedImage image = new BufferedImage(width, height, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, width, height, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public void reRenderCard() {
        BufferedImage bi = this.hm.generateCard();
        ImageIcon icon = new ImageIcon(this.resizeImage(new ImageIcon(bi), 0.5));
        this.label.setIcon(icon);
    }
}

